(function () {
    var app = angular.module('employees', ['recruitment']);

    app.directive('employees', function () {
        return {
            restrict: 'E',
            templateUrl: 'templates/employees/employees.html',
            controller: function ($scope, $rootScope, $timeout) {
                let ctrl = this;
                $scope.EmployeeTypeNames = EmployeeTypeNames;
                ctrl.tab = $rootScope.tab || 'employees';

                ctrl.fire = (employee) => {
                    Helpers.FireEmployee(employee);
                };

                ctrl.wer = Helpers.CalculateWer();

                ctrl.showEmployee = employee => {
                    if (employee != null) {
                        let workstation = $rootScope.settings.office.workstations.find(x => x.employee == employee);
                        $rootScope.closeAllUi();
                        $rootScope.selectedWorkstation = workstation;
                        
                    }
                };

                $scope.$on(GameEvents.WorkstationChange, () => {
                    ctrl.employeeStats = [...Game.Lifecycle.EmployeeStats, ...$rootScope.settings.unassignedEmployees.map(employee => {
                        return {
                            employee: employee,
                            employeeState: Enums.EmployeeStates.Unassigned,
                            progress: null,
                            productivity: employee.speed,
                            label: Helpers.GetLocalized('unassigned')
                        }
                    })];
                });
                $scope.$broadcast(GameEvents.WorkstationChange);

                let loadCandidates = () => {
                    ctrl.candidates = $rootScope.settings.candidates.filter(x =>
                        x.employeeTypeName == ctrl.employeeType.name &&
                        ctrl.tiersForEmployeeLevels[x.level] <= $rootScope.companyTier
                    );

                    if(ctrl.candidates == 0) {
                        $rootScope.settings.candidates = Generators.GenerateCandidates();
                        loadCandidates();
                        return;
                    }

                    ctrl.candidates.forEach(x => x.levelId = Helpers.GetIndexByObject(x.level));
                    ctrl.candidates = _.orderBy(
                        ctrl.candidates,
                        ['levelId', 'requiredWer'],
                        ['asc', 'asc']
                    );

                    console.log("loadCandidates()");
                };

                $scope.$broadcast(GameEvents.CandidateChange);

                ctrl.removeEmployee = employee => {
                    _.remove($rootScope.settings.candidates, x => x.id == employee.id);
                    loadCandidates();
                    $rootScope.$broadcast(GameEvents.CandidateChange);
                };
            },
            controllerAs: 'ctrl'
        };
    });
})();

